﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
#include "gameFunctions/copyObject.as"
#include "gameFunctions/nestedEval.as"
#include "gameFunctions/VOW.as"
	// evalPath.as
	// getImpliedValue.as
	// resolveContainer.as

// run()
define_appearance = function( thisCommand_obj ){
	
	
	var prom = VOW.make();
	
	
	if(TRACE_SCRIPT)
		trace("appearance");
	// set target sprite's image direciton
	var sprite = thisCommand_obj.sprite.image;
	var newData = thisCommand_obj.data.value;
	var useData = {};
	copyObject( newData, useData );
	useData.charset = nestedEval( newData.charset, "RAM", "_this" );
	if( useData.animDirection == undefined )		useData.animDirection = 1;
	if( useData.keepDirection === undefined )		useData.keepDirection = false;
	if( useData.keepDirection === true )				delete useData.direction;
	delete useData.keepDirection;		// not directly needed by setParams(), so don't accidentally inject extraneous data
	var update_prom = thisCommand_obj.sprite.image.setParams( useData ) || VOW.make().keep();
	
	
	// instantly done
	if( update_prom.getStatus() === "kept" )		return VOW.make().keep();
	
	// wait for promise
	update_prom.then(function(){
		prom.keep();
	});
	return prom;
	
	
}// define_appearance()